<?php
include 'RegisterIPN.php';
require 'connect.php';
session_start();

// Check if the necessary POST variables are set
if (!isset($_POST['session'], $_POST['amount'], $_POST['currency'], $_POST['id'], $_POST['name'], $_POST['phone'], $_POST['email'])) {
    echo "Required data not provided.";
    exit;
}

// Extract the values from the POST data
$session = intval($_POST['session']);
$amount = floatval($_POST['amount']);
$currency = strval($_POST['currency']);
$id = strval($_POST['id']);
$name = strval($_POST['name']);
$phone = strval($_POST['phone']);
$email = strval($_POST['email']);

$merchantreference = date('Y-m-d\TH:i:s.'). substr(microtime(), 2, 6). 'Z-'. rand(10000, 99999);
$callbackurl = "https://flutter.goodnewsmentalspace.com/Therapy/payments/callbackurl.php";
$branch = "BNM";

// Assuming APP_ENVIROMENT is defined somewhere in your code or configuration
if (!defined('APP_ENVIROMENT')) {
    echo "APP_ENVIROMENT is not defined.";
    exit;
}

if (APP_ENVIROMENT == 'sandbox') {
    echo "SubmitOrder Live Environment";
} elseif (APP_ENVIROMENT == 'live') {
    $submitOrderUrl = "https://pay.pesapal.com/v3/api/Transactions/SubmitOrderRequest";
} else {
    echo "Invalid APP_ENVIROMENT";
    exit;
}

// Assuming $token and $ipn_id are defined or removed if not needed
$headers = array(
    "Accept: application/json",
    "Content-Type: application/json",
    "Authorization: Bearer $token"
);

// Request payload
$data = array(
    "id" => "$merchantreference",
    "currency" => $currency,
    "amount" => $amount,
    "description" => "Payment description goes here",
    "callback_url" => "$callbackurl",
    "notification_id" => "$ipn_id",
    "branch" => "$branch",
    "billing_address" => array(
        "email_address" => "$email",
        "phone_number" => "$phone",
        "country_code" => "KE",
        "first_name" => "$name",
        "middle_name" => "", // Adjust as necessary
        "last_name" => "", // Adjust as necessary
        "line_1" => "Pesapal Limited",
        "line_2" => "",
        "city" => "",
        "state" => "",
        "postal_code" => "",
        "zip_code" => "$id"
    )
);

$ch = curl_init($submitOrderUrl);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
$responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

curl_close($ch);

$data = json_decode($response);


$redirect_url = $data->redirect_url;

// print_r($data);


$order_tracking_id = $data->order_tracking_id;

// Construct the SQL update statement
$update_query = "UPDATE users SET order_tracking_id = '$order_tracking_id' WHERE id = '$id'";

// Execute the update query
if (mysqli_query($con, $update_query)) {
    //echo "Order tracking ID updated successfully for user with ID: $id";
} else {
    //echo "Error updating order tracking ID: " . mysqli_error($your_db_connection_variable);
}

echo "<script>window.location.href='$redirect_url'</script>";

?>
